
#ifndef _COMPLEX_H
#define _COMPLEX_H

// Comments last updated by Sandy on 01/03/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:complex_(class)
*/
class complex
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-complex
	*/
	complex();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-complex
	*/
	complex(double dReal);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-complex
	*/
	complex(double dReal, double dImaginary);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-complex
	*/
	complex(complex cc);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-Conjugate
	*/
	complex Conjugate();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-GetPhase
	*/
	double GetPhase();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-GetAmplitude
	*/
	double GetAmplitude();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-m_re
	*/
	double m_re;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:complex-m_im
	*/
	double m_im;
};



/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Re
*/
//double Re(complex cc);
// better implement as macros so that can do Re(aa) = 1;
#define Re(_CC)	(_CC.m_re)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Im
*/
//double Im(complex cc);
// better implement as macros so that can do Im(aa) = 1;
#define Im(_CC)	(_CC.m_im)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Conj_(global_function)
*/
complex Conj(complex cc);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atoc_(global_function)
*/
complex atoc(LPCSTR lpcsz);

//#pragma dll(ONAG)	 //CPY 7/20/04 use new ocUtils dll for complex functions that are in msvcrt
//#pragma dll(ocUtils) ///Forest 02/18/05 QA70-6717 MOVE_COMPLEX_UTILITY_FUNCTIONS_TO_OCMATH
#pragma dll(ocmath)

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sqrt_(global_function)
*/
complex sqrt(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sin_(global_function)
*/
complex sin(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cos_(global_function)
*/
complex cos(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tan_(global_function)
*/
complex tan(complex z);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cabs_(global_function)
*/
double cabs(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:log_(global_function)
*/
complex log(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:exp_(global_function)
*/
complex exp(complex z);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ipow_(global_function)
*/
complex ipow(complex z, int n);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:rpow_(global_function)
*/
complex rpow(complex z, double x);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cpow_(global_function)
*/
complex cpow(complex z1, complex z2);

#pragma dll(@OK)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_complex_(global_function)
*/
int out_complex(LPCSTR lpcstr, complex z);



// the following functions are implemented in sys_utils.c, which is always automatically loaded


#endif // !_COMPLEX_H
